#include <iostream>

using namespace std;

int main() {
    int N;
    cin >> N;

    long long A[N];  // Žalbe koje vec postoje u svakom kontejneru
    long long C[N];  // Kapacitet svakog kontejnera

    // Unos podataka
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }

    for (int i = 0; i < N; ++i) {
        cin >> C[i];
    }

    int Q;
    cin >> Q;

    long long preliv = 0;  // Promenljiva za pracenje preliva

    // Procesiranje žalbi
    for (int i = 0; i < Q; ++i) {
        int k;
        long long x;
        cin >> k >> x;
        k--;  // Prilagodavanje indeksa na pocetak od 0

        if (x <= C[k] - A[k] + preliv) {
            // Ako ima dovoljno mesta u trenutnom kontejneru
            A[k] += x;
            preliv = 0;  // Resetujemo preliv jer smo sve smestili u trenutni kontejner
        } else {
            // Ako trenutni kontejner preliva
            long long preostali_prostor = C[k] - A[k];
            A[k] = C[k];  // Trenutni kontejner je popunjen do svojeg kapaciteta
            preliv += x - preostali_prostor;  // Ažuriranje promenljive za preliv

            // Preliv u sledeci kontejner
            for (int j = k + 1; j < N; ++j) {
                if (preliv <= C[j]) {
                    A[j] += preliv;
                    preliv = 0;
                    break;
                } else {
                    A[j] = C[j];
                    preliv -= C[j];
                }
            }
        }
    }

    // Ispis konacnog stanja kontejnera
    for (int i = 0; i < N; ++i) {
        cout << A[i] << " ";
    }

    return 0;
}